package Mediator;

import java.util.ArrayList;
import java.util.List;

class TorreDiControllo implements Mediator {
    private List<Aeromobile> aeromobili;

    public TorreDiControllo() {
        this.aeromobili = new ArrayList<>();
    }

    @Override
    public void aggiungiAeromobile(Aeromobile aeromobile) {
        aeromobili.add(aeromobile);
    }

    @Override
    public void richiediAtterraggio(Aeromobile aeromobile) {
        System.out.println("Richiesta di atterraggio ricevuta per: " + aeromobile.getIdentificativo());
        // Logica per concedere l'atterraggio
        System.out.println("Atterraggio concesso per: " + aeromobile.getIdentificativo());
    }
}